document.addEventListener('DOMContentLoaded', function() {
    const acceptBtn = document.getElementById('lgdpr-accept');
    const banner = document.getElementById('lgdpr-consent-banner');
    
    if (acceptBtn) {
        acceptBtn.addEventListener('click', function() {
            // Send AJAX request
            fetch(lgdpr_ajax.ajax_url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    action: 'lgdpr_accept_cookies',
                    nonce: lgdpr_ajax.nonce
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Fade out banner
                    banner.style.transition = 'opacity 0.3s, transform 0.3s';
                    banner.style.opacity = '0';
                    banner.style.transform = 'translateY(100%)';
                    
                    setTimeout(() => {
                        banner.remove();
                    }, 300);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                banner.remove();
            });
        });
    }
});